﻿/* 
 * PROJECT: FLARToolKit
 * --------------------------------------------------------------------------------
 * This work is based on the NyARToolKit developed by
 *   R.Iizuka (nyatla)
 * http://nyatla.jp/nyatoolkit/
 *
 * The FLARToolKit is ActionScript 3.0 version ARToolkit class library.
 * Copyright (C)2008 Saqoosha
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this framework; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * For further information please contact.
 *	http://www.libspark.org/wiki/saqoosha/FLARToolKit
 *	<saq(at)saqoosha.net>
 * 
 */

package org.libspark.flartoolkit.core.rasterreader {
	import org.libspark.flartoolkit.core.raster.rgb.FLARRgbRaster_BitmapData;
	import org.libspark.flartoolkit.core.rasterreader.IFLARRgbPixelReader;
	
	import flash.display.BitmapData;	

	/**
	 * @author Saqoosha
	 */
	public class FLARBitmapDataReader implements IFLARRgbPixelReader {
		
		private var _parent:FLARRgbRaster_BitmapData;

		public function FLARBitmapDataReader(parent:FLARRgbRaster_BitmapData) {
			this._parent = parent;
		}

		public function getPixel(i_x:int, i_y:int, o_rgb:Array):void {
			var c:int = this._parent.bitmapData.getPixel(i_x, i_y);
			o_rgb[0] = (c >> 16) & 0xff;// R
			o_rgb[1] = (c >> 8) & 0xff;// G
			o_rgb[2] = c & 0xff;// B
			return;
		}
		
		public function getPixelSet(i_x:Array, i_y:Array, i_num:int, o_rgb:Array):void {
			var bmp:BitmapData = this._parent.bitmapData;
			var c:int;
			var i:int;
			for (i = 0; i < i_num; i++) {
				c = bmp.getPixel(i_x[i], i_y[i]);
				o_rgb[i*3+0] = (c >> 16) & 0xff;
			    o_rgb[i*3+1] = (c >> 8) & 0xff;
			    o_rgb[i*3+2] = c & 0xff;
			}
		}
	}
}
